/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.flywheel.FlywheelPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;

public class RendererUtil {
    private static int formatLength = 8;

    public static void renderBlockModel(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockRendererDispatcher blockRenderer, World world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                RendererUtil.renderBlockModel(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockModel(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockRendererDispatcher blockRenderer, World world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderLayer((RenderType)type);
        blockRenderer.func_175019_b().func_228802_a_((IBlockDisplayReader)world, blockRenderer.func_184389_a(state), state, pos, matrixStack, buffer.getBuffer(type), false, new Random(), 0L, OverlayTexture.field_229196_a_);
        ForgeHooksClient.setRenderLayer(null);
    }

    public static void renderBlockModel(ResourceLocation modelLocation, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockRendererDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        blockRenderer.func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), buffer.getBuffer(cutout ? Atlases.func_228783_h_() : Atlases.func_228782_g_()), null, blockRenderer.func_175023_a().func_178126_b().getModel(modelLocation), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void addCube(IVertexBuilder builder, MatrixStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        RendererUtil.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(IVertexBuilder builder, MatrixStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        RendererUtil.addCube(builder, matrixStackIn, uOff, vOff, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(IVertexBuilder builder, MatrixStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY, boolean wrap) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.func_94212_f() - sprite.func_94209_e();
        float atlasScaleV = sprite.func_94210_h() - sprite.func_94206_g();
        float minU = sprite.func_94209_e() + atlasScaleU * uOff;
        float minV = sprite.func_94206_g() + atlasScaleV * vOff;
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * h;
        float maxV2 = minV + atlasScaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        if (up) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minU, minV, maxU, maxV2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minU, minV, maxU, maxV2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        float inc = 0.0f;
        if (wrap) {
            inc = atlasScaleU * w;
        }
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minU, minV, maxU, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minU + inc, minV, maxU + inc, maxV, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minU + 2.0f * inc, minV, maxU + 2.0f * inc, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minU + 3.0f * inc, minV, maxU + 3.0f * inc, maxV, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addQuadSide(IVertexBuilder builder, MatrixStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadSide(IVertexBuilder builder, MatrixStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        u0 = RendererUtil.getRelativeU(sprite, u0);
        u1 = RendererUtil.getRelativeU(sprite, u1);
        v0 = RendererUtil.getRelativeV(sprite, v0);
        v1 = RendererUtil.getRelativeV(sprite, v1);
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(IVertexBuilder builder, MatrixStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(IVertexBuilder builder, MatrixStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.func_227888_a_(matrixStackIn.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_225587_b_(lu, lv).func_227887_a_(matrixStackIn.func_227866_c_().func_227872_b_(), nx, ny, nz).func_181675_d();
    }

    public static void addVert(IVertexBuilder builder, MatrixStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        builder.func_227888_a_(matrixStackIn.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(RendererUtil.getRelativeU(sprite, u), RendererUtil.getRelativeV(sprite, v)).func_227891_b_(OverlayTexture.field_229196_a_).func_225587_b_(lu, lv).func_227887_a_(matrixStackIn.func_227866_c_().func_227872_b_(), nx, ny, nz).func_181675_d();
    }

    public static float getRelativeU(TextureAtlasSprite sprite, float u) {
        float f = sprite.func_94212_f() - sprite.func_94209_e();
        return sprite.func_94209_e() + f * u;
    }

    public static float getRelativeV(TextureAtlasSprite sprite, float v) {
        float f = sprite.func_94210_h() - sprite.func_94206_g();
        return sprite.func_94206_g() + f * v;
    }

    public static void renderFish(IVertexBuilder builder, MatrixStack matrixStackIn, float wo, float ho, int fishType, int combinedLightIn) {
        int textW = 64;
        int textH = 32;
        int fishW = 5;
        int fishH = 4;
        int fishv = fishType % (textH / fishH);
        int fishu = fishType / (textH / fishH);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.FISHIES_TEXTURE);
        float w = (float)fishW / (float)textW;
        float h = (float)fishH / (float)textH;
        float hw = 4.0f * w / 2.0f;
        float hh = 2.0f * h / 2.0f;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.func_94212_f() - sprite.func_94209_e();
        float atlasscaleV = sprite.func_94210_h() - sprite.func_94206_g();
        float minu = sprite.func_94209_e() + atlasscaleU * (float)fishu * w;
        float minv = sprite.func_94206_g() + atlasscaleV * (float)fishv * h;
        float maxu = atlasscaleU * w + minu;
        float maxv = atlasscaleV * h + minv;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), -hh + ho, wo, minu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), -hh + ho, -wo, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), hh + ho, -wo, maxu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), hh + ho, wo, minu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                matrixStackIn.func_227863_a_(Const.Y180);
                float temp = minu;
                minu = maxu;
                maxu = temp;
            }
            lu = 240;
            minu += atlasscaleU / 2.0f;
            maxu += atlasscaleU / 2.0f;
        }
    }

    public static void changeVertexFormat(int length) {
        formatLength = length;
    }

    private static void checkShaders() {
        if (CompatHandler.flywheel) {
            RendererUtil.changeVertexFormat(FlywheelPlugin.areShadersOn() ? 9 : 8);
        }
    }

    public static int[] moveVertices(int[] v, Direction dir, float amount) {
        RendererUtil.checkShaders();
        int axis = dir.func_176740_k().ordinal();
        float step = amount * (float)dir.func_176743_c().func_179524_a();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float original = Float.intBitsToFloat(v[i * formatLength + axis]);
            v[i * RendererUtil.formatLength + axis] = Float.floatToIntBits(original + step);
        }
        return v;
    }

    public static int[] moveVertices(int[] v, float x, float y, float z) {
        RendererUtil.checkShaders();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * RendererUtil.formatLength] = Float.floatToIntBits(originalX + x);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * RendererUtil.formatLength + 1] = Float.floatToIntBits(originalY + y);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * RendererUtil.formatLength + 2] = Float.floatToIntBits(originalZ + z);
        }
        return v;
    }

    public static int[] scaleVertices(int[] v, float scale) {
        RendererUtil.checkShaders();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * RendererUtil.formatLength] = Float.floatToIntBits(originalX * scale);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * RendererUtil.formatLength + 1] = Float.floatToIntBits(originalY * scale);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * RendererUtil.formatLength + 2] = Float.floatToIntBits(originalZ * scale);
        }
        return v;
    }

    public static int[] transformVertices(int[] v, MatrixStack stack) {
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.func_229372_a_(stack.func_227866_c_().func_227870_a_());
        v = RendererUtil.moveVertices(v, vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c());
        return v;
    }
}

